package examples.session.stateful_dd;

import javax.ejb.InvocationContext;

/**
 * This class is a lifecycle callback interceptor for the Count bean. 
 * The callback methods simply print a message when invoked by 
 * the container.
 */
public class CountCallbacks {
    
    public CountCallbacks() {}
    
    /**
     * Called by the container after construction
     */
    public void construct(InvocationContext ctx) {
        System.out.println("cb:construct()");
    }
    
    /**
     * Called by the container after activation
     */
    public void activate(InvocationContext ctx) {
        System.out.println("cb:activate()");
    }
    
    /**
     * Called by the container before passivation
     */
    public void passivate(InvocationContext ctx) {
        System.out.println("cb:passivate()");
    }
    
    /**
     * Called by the container before destruction
     */

    public void destroy(InvocationContext ctx) {
        System.out.println("cb:destroy()");
    }
    
}
